{$A+,B-,D+,E-,F-,G-,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V+,X+}
Program texview;
{
Program to QUICKLY view text in a binary file.  I got tired of how slow LIST
was for this task, so I wrote my own.  Use /? or no arguments for help.

trixter@oldskool.org
JL20060405 at 1:23am -- hey -- 01-23-4-5-06 -- Wow, that's a once-in-a-lifetime
event.  I guess it means this program will trigger the second coming of the
antichrist or something :-D

JL20231209: Sped the display a few orders of magnitude by buffering 32K
into a file, and debugging TBUFStream which flushes the buffer when
performing a GetSize for some stupid reason.
}

uses
  tfastwrite,objects,cmdlin,support;

const
  maxlinelen=128; {max line length}
  curfc:byte=6; {thanks to IBM, dark yellow MUCH darker than the others}
  curbc:byte=0;
  backfore:byte=$07;
  hiddenScreen:boolean=false;
  onlyascii:boolean=false;
  attheend:boolean=false;
  statlinestr:string[80]='PgUp/PgDn/Home/End=Navigate | a=ASCII only | f/b=fore/back col. | ESC=exit |   ';
  fbufsize=32*1024;

type
  tlinearray=array[0..maxlinelen] of byte; {leave 1 byte at front to emulate pascal string}
  plinearray=^tlinearray;

var
  f:pBUFStream;
  c:char;
  scrp:pointer;
  counter:byte;
  foo:word;
  advanced,screenstep:word;
  scrline:plinearray;
  linesize:byte;
  s:string;
  oldfc,oldbc:byte;
  l:longint;
  f_size:longint;

label
  KeepGoing;

Procedure PrintHelp;
begin
  asm
    push ds
    jmp @start
@message:
    db 0ah,'TexView v1.2, trixter@oldskool.org.  QUICKLY views text in binary files.',0dh,0ah,0ah

    db 'Usage: TV.EXE <switches> [filename] <switches>',0dh,0ah,0ah

    db 'Switches:',0dh,0ah
    db '/s+ /s- CGA "snow" handling on/off.  Eliminates CGA snow at the',0dh,0ah
    db '        expense of display speed.',0dh,0ah
    db '/h+ /h- Buffered screen writes on/off (updates entire screen at once).',0dh,0ah
    db '        May appear more visually pleasing on slow hardware.',0dh,0ah,0ah

    db 'PgDn: forward one screen page',0dh,0ah
    db 'PgUp: backward one screen page',0dh,0ah
    db 'Home: beginning of file',0dh,0ah
    db ' End: end of file',0dh,0ah
    db ' f,b: cycle foreground/background colors',0dh,0ah
    db '   a: toggles ASCII on/off (if set, only low ASCII (32-127) displayed)',0dh,0ah
    db ' ESC: exit',0dh,0ah
    db '$'

@start:
    mov ax,0900h
    lea dx,@message
    mov bx,cs
    mov ds,bx
    int 21h
    pop ds
  end;
  halt(255);
end;

begin
  if (paramcount=0) or is_Param('?') then printHelp;
  if not fileexists(non_flag_param(1)) then fatalerror(1,non_flag_param(1)+' not found');

  if param_text('s')='-' then tfPreventSnow:=false else tfPreventSnow:=true;
  if param_text('h')='-' then hiddenScreen:=false else hiddenScreen:=true;
  new(f); f^.init(non_flag_param(1),stOpenRead,fbufsize);
  f_size:=f^.getsize;
  if f^.status<>stOK then fatalerror(2,'Unknown error opening '+non_flag_param(1));

  TFastInit(80,25);
  if vidp=ptr($b000,0) then tfPreventSnow:=false;
  if hiddenScreen
    then getmem(scrp,tfScrSizeInWords*2)
    else scrp:=vidp;
  new(scrline);
  c:=#0;
  backfore:=(curbc shl 4) or curfc;
  screenstep:=(2*tfMaxScrX);
  scrline^[0]:=TFMaxScrX;
  {print the status line}
  TFastWriteXY(@statlinestr,scrp,0,TFMaxScrY-1,$70);

  repeat
    advanced:=0;
    for counter:=0 to TFMaxScrY-2 do begin {-2 so that we can have a status line}
      {erase previous screenline}
      asm
        les di,scrline
        inc di {skip over pascal string length byte}
        xor ch,ch
        mov cl,TFMaxScrX
        mov al,$04 {4 = EOT; also looks like a diamond pattern when repeated}
        cld
        rep stosb
      end;
      {are we already at the end of the file?}
      if f^.getpos >= f_size-1 then begin
        attheend:=true;
        goto KeepGoing;
      end;
      {do we have enough bytes to display?}
      if (f^.getpos+TFMaxScrX) < f_size
        then linesize:=TFMaxScrX
        else linesize:=(f_size-f^.getpos);
      {read the line}
      f^.read(scrline^[1],linesize);
      inc(advanced,linesize);
      {paint it}
KeepGoing:
      TFastWriteXYHiASCII(scrline,scrp,0,counter,backfore);
    end;
    f^.seek(f^.getpos-advanced); {seek backward what we just read}
    {Show Percentage}
    if not attheend
      then s:=inttostr((f^.getpos * 100) div f_size)+'%'
      else s:='END';
    if byte(s[0]) < 3 then s:=s+' ';
    TFastWriteXY(@s,scrp,TFMaxScrX-3,TFMaxScrY-1,$70);
    {update hidden->visible if necessary}
    if hiddenScreen
      then tfastcopyscreen(scrp,vidp,80*25*2);
    {handle user input}
    c:=upcase(readkeychar);
        case c of
    #32,'Q':begin {PgDn}
              if not attheend
                then if (f^.getpos+tfscrsizeinwords-screenstep) < f_size
                  then f^.seek(f^.getpos+tfscrsizeinwords-screenstep)
                  else f^.seek(f_size-tfscrsizeinwords-tfMaxScrX); {leave room for statusline}
            end;
     #8,'I':begin {PgUp}
              if (f^.getpos-tfscrsizeinwords+screenstep) > 0
                then f^.seek(f^.getpos-tfscrsizeinwords+screenstep)
                else f^.seek(0);
              attheend:=false;
            end;
    'G':begin {Home}
          f^.seek(0);
          attheend:=false;
        end;
    'O':begin {End}
          f^.seek(f_size-tfscrsizeinwords+TFMaxScrX); {End}
          attheend:=true;
        end;
    'A':begin
          OnlyASCII:=not OnlyASCII;
          if OnlyASCII
            then begin
              oldfc:=curfc; oldbc:=curbc; {save old fc/bc}
              curfc:=curbc {make them the same, the highlite proc will show through}
            end else begin
              curfc:=oldfc; curbc:=oldbc;
            end;
        end;
    'F':begin
          inc(curfc);
          curfc:=curfc AND 7;
          if curfc=curbc then begin {I hate invisible characters}
            inc(curfc);
            curfc:=curfc AND 7;
          end;
        end;
    'B':begin
          inc(curbc);
          curbc:=curbc AND 7;
          if curbc=curfc then begin {I hate invisible characters}
            inc(curbc);
            curbc:=curbc AND 7;
          end;
        end;
    end; {case}
    case c of
    'B','F','A':begin
        backfore:=(curbc shl 4) or curfc;
      end;
    end; {case}
  until c=#27;

  f^.done;
  {No need to free up RAM/heap because we're exiting to DOS which will
  reclaim everything anyway.}
  {dispose(f);
  dispose(scrline);
  if hiddenscreen then freemem(scrp,tfScrSizeInWords*2);}

  RestoreDOSScreen;
end.
